/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.client.gui.buttons;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.extendedexchange.client.gui.EMCFormat;
import dev.ftb.extendedexchange.client.gui.buttons.EXButton;
import dev.ftb.extendedexchange.network.NetworkHandler;
import dev.ftb.extendedexchange.network.PacketGuiButton;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class ExtractItemButton
extends EXButton {
    private final IKnowledgeProvider provider;
    private ItemStack item = ItemStack.f_41583_;
    private static final BigDecimal ONE_TENTH = BigDecimal.valueOf(1L, 1);

    public ExtractItemButton(int x, int y, IKnowledgeProvider provider) {
        super(x, y, 18, 18, b -> {});
        this.provider = provider;
    }

    @Override
    public void m_5691_() {
        if (!this.item.m_41619_()) {
            NetworkHandler.sendToServer(new PacketGuiButton("extract:" + this.item.m_41720_().getRegistryName().toString(), Screen.m_96638_()));
        }
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (!this.f_93624_) {
            return;
        }
        if (!this.item.m_41619_()) {
            Font font = Minecraft.m_91087_().f_91062_;
            Minecraft.m_91087_().m_91291_().m_115123_(this.item, this.f_93620_, this.f_93621_);
            String label = this.getExtractionCountStr();
            poseStack.m_85836_();
            poseStack.m_85837_((double)(this.f_93620_ + 17), (double)(this.f_93621_ + 12), 200.0);
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            font.m_92750_(poseStack, label, (float)(-font.m_92895_(label)), 0.0f, -1);
            poseStack.m_85849_();
        }
        if (this.m_198029_()) {
            RenderSystem.m_69472_();
            RenderSystem.m_69478_();
            RenderSystem.m_69405_((int)770, (int)771);
            ExtractItemButton.m_93172_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)-2130706433);
            RenderSystem.m_69461_();
        }
    }

    private String getExtractionCountStr() {
        long emc = ProjectEAPI.getEMCProxy().getValue(this.item);
        if (emc == 0L) {
            return "???";
        }
        String label = "";
        BigDecimal d = new BigDecimal(this.provider.getEmc()).setScale(1, RoundingMode.DOWN).divide(BigDecimal.valueOf(emc), RoundingMode.DOWN);
        if (d.compareTo(BigDecimal.ONE) >= 0) {
            label = EMCFormat.formatBigDecimal(d.setScale(0, RoundingMode.DOWN));
        } else if (d.compareTo(ONE_TENTH) >= 0) {
            label = d.toString();
        }
        return label;
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<Component> curTip, boolean shift) {
        curTip.addAll(this.item.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL)));
    }
}

